function out = extpts(X)

% This routine takes a set of points (x_1,...,x_m) in R^n as given
% and returns the extreme points of the convex hull of those points.
%
% Input:  X = [x_1;...;x_m]
%
% Output: extpts(X) = [e_1;...;e_k], where e_i is the i-th extreme
% point of co({x_1,...,x_m}).


if (size(X,2)==1) % data is one dimensional
  
  out = [min(X);max(X)];
  
else % data is two or higher dimensional
  
  % use convhulln to get the indices of the points comprising the
  % facets of co({x_1,...,x_m})
  
  K = convhulln(X,{'Pp'}); % might need 'QJ' option here
  
  % get the set of extreme points by omitting overlaps
  
  extind = K(1,:);
  
  for i=2:size(K,1)
    extind = union(extind,K(i,:));
  end
  
  % get the set of extreme points

  out = X(extind,:);
  
end
